/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	CreateExtrusion.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CFeature.h"
#include "CApplication.h"

//	Performs extrusion on Active Design and return the Extrusion it created.

using namespace ProDESKTOPLib;

HRESULT CreateExtrusion(ISketch *pSketch, double distanceAbove, int distanceBelow, double taperAngle, int side, long materialStatus, CString extrusionName, IExtrusion **pExtrusion)
{

	START_METHOD("CreateExtrusion")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;
	
	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IDesign *pDesign = NULL;
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	IExtrusion *extrusion = NULL;
	status = (GetCLASS(Extrusion))->CreateExtrusion(pDesign, pSketch, distanceAbove, distanceBelow, taperAngle, side, materialStatus, 0, &extrusion);
	CHECK_RETURN_STATUS(status)

	IOperation *operation = CAST(IOperation, extrusion);
	status = operation->SetName(extrusionName.AllocSysString());
	CHECK_RETURN_STATUS(status)
	*pExtrusion = extrusion;

	END_METHOD("CreateExtrusion")
}
